
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1072.C - Message 1072 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1072 messages.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Source\Archives\MSG1072.C_v  $
//   
//      Rev 1.15   09 Nov 1998 10:47:22   phungh
//   labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the 
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the "write to file"
//   code portion out of the interrupt handler
//   so that data is not missed because of time
//   spent too long in the interrupt handler
//   
//
//
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <share.h>

#include "gentypes.h"
#include "gencons.h"
#include "ztypes.h"
#include "zcons.h"   
#include "util.h" 
#include "display.h"

void wait(float);  
void clear_message_line(void);

extern FILE  *stream4;

   
////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1072 message from the ZMsgBuf.
//
void Dec1072(tMSGBUF *ZMsgBuf, tMSG1072 *Msg)
{                                            
   unsigned short i;
   
   // store gyro tempurature table in a file
   if((stream4 = _fsopen("gyrodata.tbl", "wt", SH_DENYWR)) != NULL){
   clear_message_line();
   ShowText("STORING GYRO TEMPERATURE TABLE DATA IN FILE ... ", CMDR, CMDC);
   
   fprintf(stream4,"GYRO TEMPERATURE TABLE DATA\n");
   fprintf(stream4,"FILENAME      : %s\n\n"  , "gyrodata.tbl");
   fprintf(stream4,"SEQ NUMBER    : %-8hd\n"   , Msg->SequenceNumber);
   fprintf(stream4,"WRITE COUNTER : %-8lu\n"   , Msg->WriteCounter);
   fprintf(stream4,"SPEED SF      : %-8hd\n"   , Msg->Speed_SF);
   fprintf(stream4,"SPEED SF DATE : %-8hu\n"   , Msg->Speed_SF_Date);
   fprintf(stream4,"SPEED SF JUMP : %-8hd\n"   , Msg->Speed_SF_Jump);

   fprintf(stream4,"ENTRY           HR BIAS        HR SCALE       HR DATE\n");
   for(i=0; i<64; i++){
      fprintf(stream4,"%6hd         %6hu         %6hu         %6hu\n",
                       i, Msg->HeadingRateBias[i], Msg->HeadingRateScale[i], Msg->HeadingRateDate[i]);
   }
   
   fclose(stream4);
   ShowText("DONE", CMDR, CMDC+50);
   }
}                                      
                                     
////////////////////////////////////////////////////////////////////////////////
//   
//   Build a Zodiac 1072 message in the ZMsgBuf. 
//
void Bld1072(tMSGBUF *ZMsgBuf, tMSG1072 *Msg)
{
   // tbd
}                                            

////////////////////////////////////////////////////////////////////////////////
//   
//   Display a Zodiac 1072 message from the ZMsgBuf.
//
void Show1072(tMSG1072 *Msg)
{
   // tbd
}                                                 
                                      
                                           
